<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Before_After_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-before-after';
	}
	
	public function get_title() {
		return esc_html__('Before After', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-h-align-stretch';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['before-after'];
	}
	
	protected function _register_controls() {
		
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Before/After Image', 'photomentor')
			]
		);
		
		
        $this->add_control(
            'image_before',
            [
                'label' => __( 'Image Before', 'photomentor' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		

        $this->add_control(
            'image_after',
            [
                'label' => __( 'Image After', 'photomentor' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

		$this->add_control(
			'control_divider_2',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		

		$this->add_control(
			'image_crop',
			[
				'label' => esc_html__( 'Crop Image?', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => '',
				'label_on' => __( 'Yes', 'photomentor' ),
				'label_off' => __( 'No', 'photomentor' ),
				'return_value' => 'yes'
			]
		);

		$this->add_control(
			'control_divider_3',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'image_crop' => 'yes'
				]
			]
		);
		

        $this->add_control(
            'image_width',
            [
                'label' => esc_html__('Image Width', 'photomentor'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1170,
                'min' => 0,
                'step' => 1,
				'condition' => [
					'image_crop' => 'yes'
				]
            ]
        );
		
		$this->add_control(
			'control_divider_4',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'image_crop' => 'yes'
				]
			]
		);
		

        $this->add_control(
            'image_height',
            [
                'label' => esc_html__('Image Height', 'photomentor'),
                'type' => Controls_Manager::NUMBER,
                'default' => 780,
                'min' => 0,
                'step' => 1,
				'condition' => [
					'image_crop' => 'yes'
				]
            ]
        );
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'divider_color',
			[
				'label' => esc_html__('Divider Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_before_after_divider' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .photomentor_before_after_divider .photomentor_before_after_right:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .photomentor_before_after_divider .photomentor_before_after_left:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .photomentor_before_after_divider .photomentor_before_after_left:before' => 'border-color: transparent {{VALUE}} transparent transparent;',
					'{{WRAPPER}} .photomentor_before_after_divider .photomentor_before_after_right:before' => 'border-color: transparent transparent transparent {{VALUE}};'
				]
			]
		);

	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$image_before = $settings['image_before'];
		$image_after = $settings['image_after'];

		$image_crop = $settings['image_crop'];
		$image_width = $settings['image_width'];
		$image_height = $settings['image_height'];

		$img_before_url = wp_get_attachment_url($image_before['id']);
		$img_after_url = wp_get_attachment_url($image_after['id']);

		if (!empty($image_before['id'])) {
			$img_meta = wp_get_attachment_metadata($image_before['id']);
			if ($image_crop == 'yes') {
				$img_set_width = $image_width;
				$img_set_height = $image_height;
			} else {
				$img_set_width = $img_meta['width'];
				$img_set_height = $img_meta['height'];
			}
		} else {
			$img_set_width = 1200;
			$img_set_height = 800;
		}

		if (empty($image_before['id'])) { 
			$img_before_url = Utils::get_placeholder_image_src();
		}
		if (empty($image_after['id'])) { 
			$img_after_url = Utils::get_placeholder_image_src();
		}

		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		?>

		<div class="photomentor_before_after_wrapper photomentor_no_select">
			<div class="photomentor_before_after">
				<?php

				if ($image_crop == 'yes') {
					echo '<img class="photomentor_before_image" src="'. aq_resize(esc_url($img_before_url), esc_attr($img_set_width), esc_attr($img_set_height), true, true, true) .'" alt="photomentor_before_image" width="'. esc_attr($img_set_width) .'" height="'. esc_attr($img_set_height) .'" />';
					echo '<div class="photomentor_after_image photomentor_js_bg_image" data-src="'. aq_resize(esc_url($img_after_url), esc_attr($img_set_width), esc_attr($img_set_height), true, true, true) .'"></div>';
				} else {
					echo '<img class="photomentor_before_image" src="'. esc_url($img_before_url) .'" alt="photomentor_before_image" width="'. esc_attr($img_set_width) .'" height="'. esc_attr($img_set_height) .'" />';
					echo '<div class="photomentor_after_image photomentor_js_bg_image" data-src="'. esc_url($img_after_url) .'"></div>';
				}
				?>
				<div class="photomentor_before_after_divider"><span class="photomentor_before_after_left"></span><span class="photomentor_before_after_right"></span></div>
				<div class="photomentor_before_after_line"></div>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}
