<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Packery_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-packery';
	}
	
	public function get_title() {
		return esc_html__('Gallery Packery', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-inner-section';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_packery'];
	}
	
	protected function _register_controls() {
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('Gallery', 'photomentor')
			]
		);
		
		$this->add_control(
			'images',
			[
				'label' => esc_html__( 'Add Images', 'photomentor' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		
		$this->add_control(
			'img_random',
			[
				'label' => esc_html__( 'Mix Images', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => '',
				'label_on' => esc_html__( 'Yes', 'photomentor' ),
				'label_off' => esc_html__( 'No', 'photomentor' ),
				'return_value' => 'yes'
			]
		);
		
		$this->add_control(
			'control_divider_1',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__('Images on Start', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 8,
				'min' => 1,
				'step' => 1,
			]
		);
		
		$this->add_control(
			'control_divider_2',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'posts_per_click',
			[
				'label' => esc_html__('Images per Click', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
				'min' => 1,
				'step' => 1,
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->add_control(
			'control_divider_3',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->add_control(
			'more_button_status',
			[
				'label' => esc_html__('Load More Button', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'show',
				'options' => [
					'show' => esc_html__('Show', 'photomentor'),
					'hide' => esc_html__('Hide', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_5',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->add_control(
			'more_button_text',
			[
				'label' => esc_html__('More Button Text', 'photomentor'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Load More', 'photomentor'),
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Gallery Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_gallery_settings',
			[
				'label' => esc_html__('Gallery Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'items_padding',
			[
				'label' => esc_html__('Spaces Between Items', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200
					]
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_gallery_item' => 'padding: 0 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .photomentor_packery_inner' => 'margin-left: -{{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_8',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'items_radius',
			[
				'label' => esc_html__('Items Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .packery-item-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'hover_type',
			[
				'label' => esc_html__('Hover Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'gradient_caption',
				'options' => [
					'gloss' => esc_html__('Gloss', 'photomentor'),
					'gradient_caption' => esc_html__('Gradient with Caption', 'photomentor'),
					'solid_plus' => esc_html__('Plus at Bottom', 'photomentor'),
					'caption' => esc_html__('Overlay with Caption', 'photomentor'),
					'magnifier' => esc_html__('Overlay with Magnifier', 'photomentor'),
					'plus' => esc_html__('Overlay with Plus', 'photomentor'),
					'overlay' => esc_html__('Just Overlay', 'photomentor'),
					'none' => esc_html__('No Hover', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type!' => ['gloss', 'gradient_caption', 'none']
				]
			]
		);
		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__('Overlay Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .packery-item-overlay' => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'hover_type!' => ['gloss', 'gradient_caption', 'none']
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'caption_typography',
				'label' => esc_html__('Caption Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .packery-item-content h4',
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_control(
			'control_divider_12',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_control(
			'caption_color',
			[
				'label' => esc_html__('Caption Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .packery-item-content h4' => 'color: {{VALUE}};'
				],
				'condition' => [
					'hover_type' => ['gradient_caption', 'caption']
				]
			]
		);
		
		$this->add_control(
			'control_divider_13',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'hover_type' => ['solid_plus', 'magnifier', 'plus']
				]
			]
		);
		
		$this->add_control(
			'marker_color',
			[
				'label' => esc_html__('Marker Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hover_type_solid_plus .packery-item-overlay:before, {{WRAPPER}} .hover_type_plus .packery-item-overlay:before, {{WRAPPER}} .hover_type_solid_plus .packery-item-overlay:after, {{WRAPPER}} .hover_type_plus .packery-item-overlay:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .hover_type_magnifier .packery-item-overlay:before' => 'color: {{VALUE}};'
				
				],
				'condition' => [
					'hover_type' => ['solid_plus', 'magnifier', 'plus']
				]
			]
		);
		
		$this->end_controls_section();
		
		// ----------------------------------------------- //
		// ---------- Load More Button Settings ---------- //
		// ----------------------------------------------- //
		$this->start_controls_section(
			'section_more_button_settings',
			[
				'label' => esc_html__('Load More Button Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'more_button_status' => 'show'
				]
			]
		);
		
		$this->start_controls_tabs('more_button_settings_tabs');
		
		// ------ Tab Settings ------ //
		$this->start_controls_tab(
			'tab_button_settings',
			[
				'label' => esc_html__('Settings', 'photomentor')
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'more_button_typography',
				'label' => esc_html__('Button Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_load_more_button'
			]
		);
		
		$this->add_control(
			'more_button_icon_status',
			[
				'label' => esc_html__('Button Icon', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('Off', 'photomentor'),
				'label_on' => esc_html__('On', 'photomentor'),
				'separator' => 'before'
			]
		);
		
		$this->add_control(
			'control_divider_14',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon',
			[
				'label' => esc_html__('Choose Icon', 'photomentor'),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'fa fa-long-arrow-right',
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_15',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon_position',
			[
				'label' => esc_html__('Button Icon Position', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'after',
				'options' => [
					'after' => esc_html__('After Text', 'photomentor'),
					'before' => esc_html__('Before Text', 'photomentor')
				],
				'condition' => [
					'more_button_icon_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_16',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'after'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon_margin_left',
			[
				'label' => esc_html__('Space Before Icon', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50
					]
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_more_button_icon' => 'margin-left: {{SIZE}}{{UNIT}};'
				],
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'after'
				]
			]
		);
		
		$this->add_control(
			'control_divider_17',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'before'
				]
			]
		);
		
		$this->add_control(
			'more_button_icon_margin_right',
			[
				'label' => esc_html__('Space After Icon', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50
					]
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_more_button_icon' => 'margin-right: {{SIZE}}{{UNIT}};'
				],
				'condition' => [
					'more_button_icon_status' => 'yes',
					'more_button_icon_position' => 'before'
				]
			]
		);
		
		$this->add_control(
			'more_button_padding',
			[
				'label' => esc_html__('Button Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_control(
			'control_divider_18',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_margin',
			[
				'label' => esc_html__('Button Margin', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_19',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_border_radius',
			[
				'label' => esc_html__('Button Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_20',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_align',
			[
				'label' => esc_html__('Button Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more' => 'text-align: {{VALUE}};'
				]
			]
		);
		
		$this->end_controls_tab();
		
		// ------ Tab Normal ------ //
		$this->start_controls_tab(
			'tab_more_button_normal',
			[
				'label' => esc_html__('Normal', 'photomentor')
			]
		);
		
		$this->add_control(
			'more_button_color',
			[
				'label' => esc_html__('Button Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_21',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_bg_color',
			[
				'label' => esc_html__('Button Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button' => 'background-color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_22',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_border_status',
			[
				'label' => esc_html__('Button Border', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'more_button_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_load_more_button',
				'condition' => [
					'more_button_border_status' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'control_divider_23',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'more_button_shadow',
				'label' => esc_html__('Button Shadow', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_load_more_button'
			]
		);
		
		$this->end_controls_tab();
		
		// ------ Tab Hover ------ //
		$this->start_controls_tab(
			'tab_more_button_hover',
			[
				'label' => esc_html__('Hover', 'photomentor')
			]
		);
		
		$this->add_control(
			'more_button_hover',
			[
				'label' => esc_html__('Button Hover Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button:hover' => 'color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_24',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'more_button_bg_hover',
			[
				'label' => esc_html__('Button Hover Background Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_load_more_button:hover' => 'background-color: {{VALUE}};'
				]
			]
		);
		
		$this->add_control(
			'control_divider_25',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'more_button_hover_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .photomentor_load_more_button:hover'
			]
		);
		
		$this->add_control(
			'control_divider_26',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'more_button_hover_shadow',
				'label' => esc_html__('Button Shadow', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_load_more_button:hover'
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$images = $settings['images'];
		$posts_per_page = $settings['posts_per_page'];
		$posts_per_click = $settings['posts_per_click'];
//		$columns = $settings['columns'];
		$more_button_status = $settings['more_button_status'];
		$more_button_text = $settings['more_button_text'];
//		$items_padding = $settings['items_padding'];
		$hover_type = $settings['hover_type'];
		$more_button_icon_status = $settings['more_button_icon_status'];
		$more_button_icon_position = $settings['more_button_icon_position'];
		$more_button_icon = $settings['more_button_icon'];
		
		$img_width = 960;
		$img_height = 960;
		$uniqid = mt_rand(0, 9999);
		$packery_array = array();
		$img_array = array();
		$demo_array = array();
		$imgCounter = 0;
		
		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($images)) {
			return;
		}
		if ($settings['img_random'] == 'yes') {
			shuffle($images);
		}
        
        /* Customizer Lightbox Settings*/
        $lightbox_overlay = get_theme_mod('photomentor_lightbox_overlay', '0.7');
        $caption_state = get_theme_mod('photomentor_lightbox_title', 'none');
        $caption_padding_top = get_theme_mod('photomentor_lightbox_padding-top', '14');
        $caption_padding_bottom = get_theme_mod('photomentor_lightbox_padding-bottom', '14');
        $caption_font_size = get_theme_mod('photomentor_lightbox_font-size', '16');
        if (get_theme_mod('photomentor_lightbox_uppercase', false)) {
            $caption_uppercase = 'yes';
        } else {
            $caption_uppercase = 'no';
        }

		?>
		
		<div class="photomentor_gallery_packery_container">
			<div class="photomentor_packery_wrapper photomentor_photoswipe_wrapper photomentor_packery_<?php echo esc_attr($uniqid); ?> <?php echo ((get_option('photomentor_demo')) ? 'demo_mode' : ''); ?>" data-uniqid="<?php echo esc_attr($uniqid); ?>" data-perload="<?php echo esc_attr($posts_per_click); ?>" data-caption="<?php echo esc_attr($caption_state); ?>" data-caption-top="<?php echo absint($caption_padding_top); ?>" data-caption-bottom="<?php echo absint($caption_padding_bottom); ?>" data-caption-size="<?php echo absint($caption_font_size); ?>" data-caption-uppercase="<?php echo esc_attr($caption_uppercase); ?>" data-overlay="<?php echo esc_attr($lightbox_overlay); ?>">
				<div class="photomentor_packery_inner photomentor_gallery_packery_isotope_trigger is_packery hover_type_<?php echo esc_attr($hover_type); ?>" data-perload="<?php echo esc_attr($posts_per_click); ?>">
					<?php
					foreach ( $images as $index => $image ) {
						$photoCaption = '';
						
						$attach_meta = photomentor_get_attachment($image['id']);
						$img_meta = wp_get_attachment_metadata($image['id']);
						$img_original_width = $img_meta['width'];
						$img_original_height = $img_meta['height'];
						
						$attach_meta = photomentor_get_attachment($image['id']);
						$photoTitle = $attach_meta['caption'];
                        $photoCaption = '';

                        if ($caption_state == 'title') {
                            $photoCaption = $attach_meta['title'];
                        }                        
                        if ($caption_state == 'caption') {
                            $photoCaption = $attach_meta['caption'];
                        }
                        if ($caption_state == 'description') {
                            $photoCaption = $attach_meta['description'];
                        }
                        if ($photoCaption !== '') {
                            $PCREpattern = '/\r\n|\r|\n/u';
                            $photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
                        }                        
                        
						$photoAlt = $attach_meta['alt'];
						
						$featured_image = wp_get_attachment_url($image['id']);
						if (strlen($featured_image[0]) > 0) {
							$featured_image_url = aq_resize(esc_url($featured_image), esc_attr($img_width), esc_attr($img_height), true, true, true);
						} else {
							$featured_image_url = '';
						}
						
						$featured_image = wp_get_attachment_image_src($image['id'], 'original');
						
						
						$img_array['attach_id'] = esc_attr($image['id']);
						$img_array['slide_type'] = 'image';
						$img_array['title'] = esc_attr($photoTitle);
						$img_array['capt'] = esc_attr($photoCaption);
						$img_array['alt'] = esc_attr($photoAlt);
						$img_array['thmb'] = esc_url($featured_image_url);
						$img_array['url'] = esc_url($featured_image[0]);
						$img_array['count'] = esc_attr($imgCounter);
						$img_array['size'] = esc_attr($img_original_width) .'x'. esc_attr($img_original_height);
						
						$imgCounter++;
						
						array_push($packery_array, $img_array);
					}
					
					if ($posts_per_page > count($packery_array)) {
						$posts_per_page = count($packery_array);
					}
					
					$i = 0;
					$count = 0;
		
					while ($i < $posts_per_page) {
						$count++;
						if ($count > 8) {
							$count = 1;
						}
						if ($packery_array[$i]['slide_type'] == 'image') {
							$thishref = wp_get_attachment_url($packery_array[$i]['attach_id']);
							$thisvideoclass = '';
						} else if ($packery_array[$i]['slide_type'] == 'video') {
							$thishref = $packery_array[$i]['src'];
							$thisvideoclass = 'video_zoom';
						}
						$photoTitle = '';
						$photoTitle = $packery_array[$i]['title'];
						if (isset($photoTitle) && $photoTitle !== '') {
							$photoTitle = str_replace('"', "'", $photoTitle);
						}
                        
                        $photoCaption = '';
                        $photoCaption = $packery_array[$i]['capt'];
						if (isset($photoCaption) && $photoCaption !== '') {
							$photoCaption = str_replace('"', "'", $photoCaption);
						}

						$photoAlt = $packery_array[$i]['alt'];
						$imgCounter = $packery_array[$i]['count'];
						$featured_image = $packery_array[$i]['url'];
						$img_thmb = $packery_array[$i]['thmb'];
						?>
					
						<div class="photomentor_gallery_item packery-item packery-item<?php echo esc_attr($count); ?> element anim_el anim_el2 load_anim packery_b2p" data-count="<?php echo esc_attr($count); ?>" data-uniqid = "<?php echo esc_attr($uniqid); ?>">
							<div class="packery-item-inner" style="background: url('<?php echo esc_url($img_thmb); ?>')" data-src="<?php echo esc_url($img_thmb); ?>">
								<a class="photomentor_pswp_slide photomentor_dp photomentor_no_select" href="<?php echo esc_url($featured_image); ?>" data-elementor-open-lightbox="no" data-size="<?php echo esc_attr($packery_array[$i]['size']); ?>" data-count="<?php echo esc_attr($i); ?>" data-caption="<?php echo esc_attr($photoCaption); ?>">
									<div class="packery-item-content">
										<h4><?php echo esc_html($photoTitle); ?></h4>
									</div>
									
									<div class="packery-item-overlay"></div>
								</a>
								
								<div class="photomentor-img-preloader"></div>
							</div>
						</div>
						<?php
						if (get_option('photomentor_demo') == 'true') {
							$demo_array[$i] = $packery_array[$i];
						}
						unset($packery_array[$i]);
						$i++;
					}
					?>
				</div>
				
				<?php
				if (isset($packery_array) && count($packery_array) > 0) {
					?>
					<div class="photomentor_packery_gallery_array" data-id = "<?php echo esc_attr($uniqid); ?>">
						<?php
						
						foreach ($packery_array as $image) {
							?>
							<div class="photomentor_packery_array_item"
								 data-id = "<?php echo esc_attr($uniqid); ?>"
								 data-type = "<?php echo esc_attr($image['slide_type']); ?>"
								 data-img = "<?php echo esc_url($image['url']); ?>"
								 data-thmb = "<?php echo esc_url($image['thmb']); ?>"
								 data-title = "<?php echo esc_attr($image['title']); ?>"
                                 data-caption="<?php echo esc_attr($image['capt']); ?>"
								 data-alt = "<?php echo esc_attr($image['alt']); ?>"
								 data-counter = "<?php echo esc_attr($image['count']); ?>"
								 data-size = "<?php echo esc_attr($image['size']); ?>"
							></div>
							<?php
						}
						if (get_option('photomentor_demo') == 'true') {
							foreach ($demo_array as $image) {
								?>
								<div class="photomentor_packery_array_item"
									 data-id = "<?php echo esc_attr($uniqid); ?>"
									 data-type = "<?php echo esc_attr($image['slide_type']); ?>"
									 data-img = "<?php echo esc_url($image['url']); ?>"
									 data-thmb = "<?php echo esc_url($image['thmb']); ?>"
									 data-title = "<?php echo esc_attr($image['title']); ?>"
                                     data-caption="<?php echo esc_attr($image['capt']); ?>"
									 data-alt = "<?php echo esc_attr($image['alt']); ?>"
									 data-counter = "<?php echo esc_attr($image['count']); ?>"
									 data-size = "<?php echo esc_attr($image['size']); ?>"
								></div>
								<?php
							}
						}
						?>
					</div>
					
					<?php
					if ($more_button_status == 'show') {
						?>
						<div class="photomentor_load_more packery_loadmore_wrapper">
							<a class="photomentor_load_more_button packery_load_more" href="<?php echo esc_js("javascript:void(0)"); ?>">
								<?php
								if ($more_button_icon_status == 'yes' && $more_button_icon_position == 'before') {
									?>
									<i class="photomentor_more_button_icon <?php echo esc_attr($more_button_icon); ?>"></i>
									<?php
								}
								
								echo esc_html($more_button_text);
								
								if ($more_button_icon_status == 'yes' && $more_button_icon_position == 'after') {
									?>
									<i class="photomentor_more_button_icon <?php echo esc_attr($more_button_icon); ?>"></i>
									<?php
								}
								?>
							</a>
						</div>
						<?php
					}
				}
				?>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}

