<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

namespace Photomentor\Core\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Photomentor_Gallery_Shift_Custom_Widget extends Widget_Base {
	
	public function get_name() {
		return 'photomentor-gallery-shift-custom';
	}
	
	public function get_title() {
		return esc_html__('Custom Split Shift', 'photomentor');
	}
	
	public function get_icon() {
		return 'eicon-slider-vertical';
	}
	
	public function get_categories() {
		return ['photomentor_gallery_widgets'];
	}
	
	public function get_script_depends() {
		return ['gallery_split'];
	}
	
	protected function _register_controls() {
		// ----------------------------- //
		// ---------- Content ---------- //
		// ----------------------------- //
		$this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__('General', 'photomentor')
			]
		);
		
		$this->add_control(
			'shift_items',
			[
				'label' => esc_html__('Add Items', 'photomentor'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'slide_image',
						'label' => esc_html__('Select Image', 'photomentor'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						]
					],
					[
						'name' => 'slide_caption_type',
						'label' => esc_html__( 'Caption Type', 'photomentor' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'default',
						'options' => [
							'default' => esc_html__( 'Default', 'photomentor' ),
							'custom' => esc_html__( 'Custom', 'photomentor' ),
						]
					],
					[
						'name' => 'slide_caption',
						'label' => esc_html__('Slide Caption', 'photomentor'),
						'type' => Controls_Manager::TEXT,
						'default' => '',
						'condition' => [
							'slide_caption_type' => 'custom'
						]
					],
					[
						'name' => 'slide_url',
						'label' => esc_html__('Link URL', 'photomentor'),
						'type' => Controls_Manager::URL,
						'default' => [
							'url' => '',
							'is_external' => 'true',
						],
						'placeholder' => esc_html__( 'http://your-link.com', 'photomentor' ),
					]
				]
			]
		);
		
		$this->add_control(
			'control_divider_0x',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'gallery_view_type',
			[
				'label' => esc_html__('Gallery View Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'shift',
				'options' => [
					'shift' => esc_html__('Shift', 'photomentor'),
					'ribbon' => esc_html__('Split (Ribbon)', 'photomentor')
				]
			]
		);

		$this->add_control(
			'gallery_type',
			[
				'label' => esc_html__('Split Layout', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'vertical',
				'options' => [
					'vertical' => esc_html__('Vertical', 'photomentor'),
					'horizontal' => esc_html__('Horizontal', 'photomentor')
				],
                'prefix_class' => 'photomentor_split_',
				'condition' => [
					'gallery_view_type' => 'ribbon'
				]
			]
		);
		
		$this->add_control(
			'control_divider_0',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'infinity_scroll',
			[
				'label' => esc_html__('Infinity Scroll', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('Off', 'photomentor'),
				'label_on' => esc_html__('On', 'photomentor')
			]
		);
		
		$this->add_control(
			'control_divider_2',
			[
				'type' => Controls_Manager::DIVIDER
			]
		);
		
		$this->add_control(
			'module_height_state',
			[
				'label' => esc_html__('Module Height Type', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'screen_height',
				'options' => [
					'auto' => esc_html__('Auto', 'photomentor'),
					'screen_height' => esc_html__('Screen Height', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_1x',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'exclude_class',
			[
				'label' => esc_html__('Reduce Height By Classes', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1ec',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_classes',
			[
				'label' => esc_html__('Classes to Exclude (separate by commas)', 'photomentor'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_class' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_1ecx',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
				]
			]
		);

		$this->add_control(
			'exclude_height',
			[
				'label' => esc_html__('Reduce Height in PX', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
				'condition' => [
					'module_height_state' => 'screen_height'
				]
			]
		);

		$this->add_control(
			'control_divider_1eh',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'reduce_height',
			[
				'label' => esc_html__('Height to Reduce, PX', 'photomentor'),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'step' => 1,
				'condition' => [
					'module_height_state' => 'screen_height',
					'exclude_height' => 'yes'
				]
			]
		);

		$this->add_control(
			'control_divider_3',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'module_height_state' => 'custom'
				]
			]
		);
		
		$this->add_control(
			'module_height',
			[
				'label' => esc_html__('Module Height', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 750,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000
					]
				],
				'condition' => [
					'module_height_state' => 'custom'
				],
				'selectors' => [
					'{{WRAPPER}} .photomentor_split_wrapper_custom_height' => 'height: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Gallery Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_gallery_settings',
			[
				'label' => esc_html__('Gallery Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'titles_state',
			[
				'label' => esc_html__('Titles State', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'always_show',
				'options' => [
					'always_show' => esc_attr__('Always Show', 'photomentor'),
					'always_hide' => esc_attr__('Always Hide', 'photomentor'),
					'show_on_hover' => esc_attr__('Show on Hover', 'photomentor'),
				]
			]
		);
		
		$this->add_control(
			'control_divider_7',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'titles_state!' => 'always_hide'
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__('Title Typography', 'photomentor'),
				'selector' => '{{WRAPPER}} .photomentor_split_title',
				'condition' => [
					'titles_state!' => 'always_hide'
				]
			]
		);
		
		$this->add_control(
			'control_divider_8',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'titles_state!' => 'always_hide'
				]
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Title Color', 'photomentor'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_split_title' => 'color: {{VALUE}};'
				],
				'condition' => [
					'titles_state!' => 'always_hide'
				]
			]
		);
		
		$this->add_control(
			'control_divider_9',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'titles_state!' => 'always_hide'
				]
			]
		);
		
		$this->add_control(
			'title_align',
			[
				'label' => esc_html__('Title Alignment', 'photomentor'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'photomentor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'photomentor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'photomentor' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .photomentor_split_title' => 'text-align: {{VALUE}};'
				],
				'condition' => [
					'titles_state!' => 'always_hide'
				]
			]
		);
		
		$this->add_control(
			'control_divider_10',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'overlay_state',
			[
				'label' => esc_html__('Overlay', 'photomentor'),
				'type' => Controls_Manager::SELECT,
				'default' => 'on',
				'options' => [
					'on' => esc_html__('On', 'photomentor'),
					'off' => esc_html__('Off', 'photomentor'),
					'custom' => esc_html__('Custom', 'photomentor')
				]
			]
		);
		
		$this->add_control(
			'control_divider_11',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'overlay_state' => 'custom'
				]
			]
		);
		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'photomentor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .photomentor_split_custom_overlay' => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'overlay_state' => 'custom'
				]
			]
		);
		
		$this->end_controls_section();
		
		// -------------------------------------- //
		// ---------- Controls Settings ---------- //
		// -------------------------------------- //
		$this->start_controls_section(
			'section_controls_settings',
			[
				'label' => esc_html__('Controls Settings', 'photomentor'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'controls_state',
			[
				'label' => esc_html__('Slider Controls', 'photomentor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__('No', 'photomentor'),
				'label_on' => esc_html__('Yes', 'photomentor'),
                'prefix_class' => 'photomentor_slider_controls_',
			]
		);
		
		$this->add_control(
			'controls_style_divider',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'controls_state' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'controls_size',
			[
				'label' => esc_html__('Size', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control i' => 'font-size: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'controls_padding',
			[
				'label' => esc_html__('Padding', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);
		
		$this->add_responsive_control(
			'controls_margin',
			[
				'label' => esc_html__('Spacing', 'photomentor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20,
					'unit' => 'px'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'condition' => [
					'controls_state' => 'yes'
				],
                'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control.photomentor_split_btn_prev' => 'left: calc(50% - {{SIZE}}{{UNIT}});',
					'{{WRAPPER}} a.photomentor_slider_control.photomentor_split_btn_next' => 'right: calc(50% - {{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.photomentor_split_vertical a.photomentor_slider_control.photomentor_split_btn_prev' => 'left: calc(50% - {{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.photomentor_split_vertical a.photomentor_slider_control.photomentor_split_btn_next' => 'right: calc(50% - {{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.photomentor_split_horizontal a.photomentor_slider_control.photomentor_split_btn_prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.photomentor_split_horizontal a.photomentor_slider_control.photomentor_split_btn_next' => 'right: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs('more_button_settings_tabs');
	
            // ------ Tab Normal ------ //
            $this->start_controls_tab(
                'tab_control_normal',
                [
                    'label' => esc_html__('Normal', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

                $this->add_control(
                    'controls_bg',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Tab Hover ------ //
            $this->start_controls_tab(
                'tab_controls_hover',
                [
                    'label' => esc_html__('Hover', 'photomentor'),
                    'condition' => [
                        'controls_state' => 'yes'
                    ]
                ]
            );

                $this->add_control(
                    'controls_color_hover',
                    [
                        'label' => esc_html__('Color', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control:hover' => 'color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );
        
                $this->add_control(
                    'controls_bg_hover',
                    [
                        'label' => esc_html__('Background', 'photomentor'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} a.photomentor_slider_control:hover' => 'background-color: {{VALUE}};'
                        ],
                        'separator' => 'before',
                        'condition' => [
                            'controls_state' => 'yes'
                        ]
                    ]
                );

            $this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->add_control(
			'controls_border_radius',
			[
				'label' => esc_html__('Border Radius', 'photomentor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px','%'],
				'selectors' => [
					'{{WRAPPER}} a.photomentor_slider_control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'controls_state' => 'yes'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

	}
	
	protected function render() {
		$settings = $this->get_settings();
		
		$shift_items = $settings['shift_items'];
		$infinity_scroll = $settings['infinity_scroll'];
		$titles_state = $settings['titles_state'];
		$overlay_state = $settings['overlay_state'];
		$controls_state = $settings['controls_state'];
		$module_height_state = $settings['module_height_state'];
		$titles_align = $settings['title_align'];
		$view_type = $settings['gallery_view_type'];
		
		if ($infinity_scroll == 'yes') {
			$infinity_class = 'infinity_scroll';
		} else {
			$infinity_class = '';
		}
		
		$title_state_class = 'titles_' . $titles_state;
		
		$uniqid = $this->get_id();

		$additional_class = '';
		
		$exclude_class = $settings['exclude_class'];
		$reduce_classes = $settings['reduce_classes'];
		$exclude_height = $settings['exclude_height'];
		$reduce_height = $settings['reduce_height'];
		
		if ($exclude_class == 'yes') {
			$additional_class = $additional_class . ' exclude_class';
		}
		if ($exclude_height == 'yes') {
			$additional_class = $additional_class . ' exclude_height';
		}

		// ------------------------------------ //
		// ---------- Widget Content ---------- //
		// ------------------------------------ //
		if (empty($shift_items)) {
			return;
		}
		?>
		
		<div class="photomentor_gallery_split_container">
				<?php
				if ($module_height_state == 'auto') {
					echo '
			<div class="photomentor_split_wrapper photomentor_no_select photomentor_split_wrapper'. esc_attr($uniqid) .' photomentor_module_loading auto_height '. esc_attr($infinity_class) .' photomentor_split_'. esc_attr($view_type) .' photomentor_split_title_'. esc_attr($titles_align) .'" data-id="'. esc_attr($uniqid) .'">';
				} else if ($module_height_state == 'screen_height') {
					echo '
			<div class="photomentor_split_wrapper photomentor_no_select photomentor_split_wrapper'. esc_attr($uniqid) .' photomentor_module_loading screen_height '. esc_attr($infinity_class) .' photomentor_split_'. esc_attr($view_type) .' photomentor_split_title_'. esc_attr($titles_align) .' '. esc_attr($additional_class) .'" data-id="'. esc_attr($uniqid) .'" data-classes = "'. esc_attr($reduce_classes) .'" data-rheight = "'. esc_attr($reduce_height) .'">';
				} else {
					echo '
			<div class="photomentor_split_wrapper photomentor_split_wrapper_custom_height photomentor_no_select photomentor_split_wrapper'. esc_attr($uniqid) .' photomentor_module_loading '. esc_attr($infinity_class) .' photomentor_split_'. esc_attr($view_type) .' photomentor_split_title_'. esc_attr($titles_align) .'" data-id="'. esc_attr($uniqid) .'">';
				}
				?>
			
				<div class="photomentor_split <?php echo esc_attr($title_state_class); ?>">
					<?php
					$count = 0;
					$photomentor_base_count = 1;
					$photomentor_right_count = 1;
					$photomentor_left_count = 1;
					foreach ( $shift_items as $item ) {
						
						$slide_image = $item['slide_image'];
						$slide_caption_type = $item['slide_caption_type'];
						$slide_caption = $item['slide_caption'];
						$slide_url = $item['slide_url'];

						$count++;
						if(($photomentor_base_count % 2) == 0){
							$photomentor_slide_class = 'photomentor_right_slide'.$photomentor_right_count;
							$photomentor_slide_style = 'photomentor_right_slide';
							$photomentor_data_count = $photomentor_right_count;
							$photomentor_right_count++;
						} else {
							$photomentor_slide_class = 'photomentor_left_slide'.$photomentor_left_count;
							$photomentor_slide_style = 'photomentor_left_slide';
							$photomentor_data_count = $photomentor_left_count;
							$photomentor_left_count++;
						}
						$photomentor_base_count++;
						
						$photoCaption = '';
						$attach_meta = photomentor_get_attachment($slide_image['id']);
						if ($slide_caption_type == 'default') {
							$photoTitle = $attach_meta['caption'];
						} else {
							$photoTitle = $item['slide_caption'];
						}
						$photoAlt = $attach_meta['alt'];
						$PCREpattern = '/\r\n|\r|\n/u';
						
						$slide_image = wp_get_attachment_image_src($slide_image['id'], 'original');
						
						$target = 'target="_self"';
						$nofollow = '';
						if ($slide_url['is_external'] == 'true' || $slide_url['is_external'] == 'on') {
							$target = 'target="_blank"';
						}
						if ($slide_url['nofollow'] == 'true' || $slide_url['nofollow'] == 'on') {
							$nofollow = 'rel="nofollow"';
						}

						?>
						<div class="photomentor_split_slide photomentor_split2preload <?php echo esc_attr($photomentor_slide_class) . ' ' . esc_attr($photomentor_slide_style); ?> photomentor_js_bg_image" data-src="<?php echo esc_url($slide_image[0]); ?>" data-count="<?php echo esc_attr($photomentor_data_count); ?>">
							<?php
							if ($titles_state !== 'always_hide') {
								echo '<h2 class="photomentor_split_title">'. esc_html($photoTitle) .'</h2>';
							}
							if ($overlay_state == 'on') {
								echo '<div class="photomentor_split_gradient"></div>';
							}
							if ($overlay_state == 'custom') {
								echo '<div class="photomentor_split_custom_overlay"></div>';
							}
							echo '<a href="'. esc_url($slide_url['url']) .'" '. $target .' '. $nofollow .'></a>';
							?>
						</div>
						<?php
					}
					?>
				</div>
				
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photomentor_slider_control photomentor_split_btn_prev"><i class="pm-icon-angle-down"></i><i class="pm-icon-angle-left"></i></a>
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photomentor_slider_control photomentor_split_btn_next"><i class="pm-icon-angle-up"></i><i class="pm-icon-angle-right"></i></a>
			</div>
		</div>
		<?php
	}
	
	protected function content_template() {}
	
	public function render_plain_content() {}
}

