"use strict";
function photomentor_setup() {
	/* Before After Module Setup*/
	if (jQuery('.photomentor_before_after').size() > 0) {
		jQuery('.photomentor_before_after').each(function() {
			if (jQuery(this).width() > jQuery(this).find('.photomentor_before_image').width()) {
				jQuery(this).css('max-width', jQuery(this).find('.photomentor_before_image').width()+'px');
			} else {
				jQuery(this).css('max-width', 'auto');
			}
			jQuery(this).find('.photomentor_after_image').css('width', '50%');
			jQuery(this).find('.photomentor_before_after_divider').css('left', '50%');
		});
	}
}

jQuery(window).on('elementor/frontend/init', function () {
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-before-after.default', function ($scope) {

		jQuery($scope).find('.photomentor_js_bg_image').each(function() {
			jQuery(this).css('background-image', 'url('+jQuery(this).attr('data-src')+')');
		});
		photomentor_setup();

		jQuery($scope).find('.photomentor_before_after').on('mousemove', function(e) {
			var this_offset = jQuery(this).offset().left,
				mouse_pos = e.pageX - this_offset,
				current_pos = jQuery(this).find('.photomentor_after_image').width();
			jQuery(this).find('.photomentor_after_image').width(mouse_pos);
			jQuery(this).find('.photomentor_before_after_divider').css('left', mouse_pos + 'px');
		});

		jQuery($scope).find('.photomentor_before_after').on('touchmove', function(e) {
			var touch = e.originalEvent.touches[0],
				this_offset = jQuery(this).offset().left,
				set_pos = touch.pageX - this_offset;
			if (set_pos < 0) set_pos = 0;
			if (set_pos > jQuery(this).width()) set_pos = jQuery(this).width();

			jQuery(this).find('.photomentor_after_image').width(set_pos);
			jQuery(this).find('.photomentor_before_after_divider').css('left', set_pos + 'px');
		});
	});
});

jQuery(window).on('resize',function(){
	photomentor_setup();
});
jQuery(window).on('load',function(){
	photomentor_setup();
});