"use strict";
var photomentor_grid_array = [];

function register_grid_gallery($this_obj) {
	photomentor_grid_array["photomentor_grid_" + $this_obj.attr('data-uniqid')] = {};
	var this_array = photomentor_grid_array["photomentor_grid_" + $this_obj.attr('data-uniqid')];
	this_array.id = $this_obj.attr('data-uniqid');
	this_array.showed = 0;
	this_array.items = [];

	if (!elementorFrontend.isEditMode()) {
		// Lazy Loading
		if (jQuery('.lazy_loading').length) {
			jQuery('.lazy_loading').each(function() {
				var $this = jQuery(this);
				if (!$this.hasClass('portfel_ajax_query_posts_disabled')) {
					photomentor_check_lazy($this);
				}
			});
			photomentor_window.on('scroll', function() {
				jQuery('.lazy_loading').each(function() {
					var $this = jQuery(this);
					if (!$this.hasClass('portfel_ajax_query_posts_disabled')) {
						photomentor_check_lazy($this);
					}
				});
			});
		}
	}

	var this_items_array = this_array.items;
	if ($this_obj.find('.photomentor_grid_gallery_array').length) {
		$this_obj.find('.photomentor_grid_gallery_array').each(function() {
			jQuery(this).find('.photomentor_grid_array_item').each(function() {
				var $this = jQuery(this),
					photomentor_grid_item = {};
				photomentor_grid_item.slide_type = $this.attr('data-type');
				photomentor_grid_item.img = $this.attr('data-img');
				photomentor_grid_item.thmb = $this.attr('data-thmb');
				photomentor_grid_item.title = $this.attr('data-title');
				photomentor_grid_item.capt = $this.attr('data-caption');
				photomentor_grid_item.alt = $this.attr('data-alt');
				photomentor_grid_item.overlay = $this.attr('data-overlay');
				photomentor_grid_item.counter = $this.attr('data-counter');
				photomentor_grid_item.size = $this.attr('data-size');
				this_items_array.push(photomentor_grid_item);
			});
			jQuery(this).remove();
		});
	}

	this_array.obj = $this_obj;

	this_array.init = function () {
		var this_obj = this;
		this.obj.find('.grid_load_more').on("click", function () {
			this_obj.loadmore.call(this_obj);
		});
		this.setup.call(this);
		this.preloader.call(this);
	};

	this_array.preloader = function() {
		var this_obj = this,
			$this_dom = this.obj;
		if ($this_dom.find('.load_anim_grid:first').size() > 0) {
			(function (img, src) {
				img.src = src;
				img.onload = function () {

					$this_dom.find('.load_anim_grid:first').removeClass('load_anim_grid').removeClass('anim_el').animate({
						'z-index': '15'
					}, 200, function() {
						$this_dom.find('.photomentor_grid_inner').isotope('layout');
						this_obj.setup.call(this_obj);
						this_obj.preloader.call(this_obj);
					});
				};
			}(new Image(), $this_dom.find('.load_anim_grid:first').find('img').attr('src')));
		} else {
			if (!elementorFrontend.isEditMode()) {
				if ($this_dom.find('.lazy_loading').length) {
					photomentor_check_lazy($this_dom.find('.lazy_loading'));
				}
			}
			this_obj.setup.call(this_obj);
		}
	};

	this_array.setup = function() {
		var this_obj = this,
			$this_dom = this.obj,
			$photomentor_dp = $this_dom.find('.photomentor_dp');
		if (jQuery('body').hasClass('photomentor_drag_protection')) {
			$photomentor_dp.on('mousedown',function(e){
				e.preventDefault();
			});
		}
		$this_dom.find('.grid-item').each(function(){
			if (jQuery(this).hasClass('anim_el2')) {
				jQuery(this).removeClass('anim_el2');
			}
		});
		if ($this_obj.find('.photomentor_grid_inner').size() > 0) {
			$this_dom.find('.photomentor_grid_inner').isotope('layout');
			setTimeout("jQuery('.photomentor_grid_inner').isotope('layout')",1000);
		}
	};

	this_array.loadmore = function() {
		var this_obj = this,
			$this_dom = this.obj,
			photomentor_what_to_append = '',
			photomentor_grid_post_per_page = $this_dom.attr('data-perload'),
			photomentor_uniqid = this.id,
			photomentor_allposts = this.items.length,
			photomentor_count = $this_dom.find('.grid-item').size(),
			photomentor_ins_container = $this_dom.find('.photomentor_grid_inner'),
			photomentor_load_more_button = $this_dom.find('.grid_load_more'),
			items_showed = this_obj.showed,
			last_demo_load = false;		
		
		if (this.showed >= photomentor_allposts) {
            if ($this_dom.hasClass('demo_mode')) {
                this_obj.showed = 0;
				this_obj.loadmore.call(this_obj);
            } else {
				photomentor_load_more_button.slideUp(300);
			}
		} else {
			var photomentor_now_step = items_showed + parseInt(photomentor_grid_post_per_page) - 1;
			if ((photomentor_now_step + 1) < photomentor_allposts) {
				var photomentor_limit = photomentor_now_step;
			} else {
				if ($this_dom.hasClass('demo_mode')) {
					this_obj.showed = 0;
					if ((photomentor_now_step + 1) == photomentor_allposts) {
						last_demo_load = true;
						var photomentor_limit = photomentor_now_step;
					} else {
						this_obj.loadmore.call(this_obj);
					}
				} else {
					var photomentor_limit = photomentor_allposts - 1;
					photomentor_load_more_button.slideUp(300);
				}
			}

			var photomentor_swipebox_class = '';
			if (jQuery('.photomentor_single_gallery_wrapper ').size() > 0) {
				photomentor_swipebox_class = 'swipebox';
			}
			for (var i = items_showed; i <= photomentor_limit; i++) {
				var photomentor_thishref = this_obj.items[i].img,
					photomentor_what_to_append = photomentor_what_to_append +'\
		<div class="photomentor_gallery_item grid-item element anim_el anim_el2 load_anim_grid grid_b2p">\
			<div class="grid-item-inner">\
				<a href="' + photomentor_thishref +'" class="photomentor_pswp_slide photomentor_dp photomentor_no_select" data-elementor-open-lightbox="no" data-size="'+ this.items[i].size +'" data-count="'+ photomentor_count +'" data-caption="'+ this.items[i].capt +'">\
					<img src="'+ this.items[i].thmb +'" alt="' + this.items[i].alt + '" class="grid_thmb"/>\
					<div class="grid-item-content">\
						<h4>'+ this.items[i].title +'</h4>\
					</div>\
					<div class="grid-item-overlay"></div>\
				</a>\
				<div class="photomentor-img-preloader"></div>\
			</div>\
		</div>';
				photomentor_count++;

				if (!elementorFrontend.isEditMode()) {
					// PSWP React
					if (this.items[i].slide_type == 'video') {
						if(photomentor_thishref.indexOf('youtu') + 1) {
							//YT Video
							var videoid_split = photomentor_thishref.split('='),
								videoid = videoid_split[1],
								photomentor_pswp_html = '<div class="photomentor_pswp_video_wrapper"><iframe width="100%" height="100%" src="https://www.youtube.com/embed/' + videoid + '?controls=1&autoplay=0&showinfo=0&modestbranding=1&wmode=opaque&rel=0&hd=1&disablekb=1" frameborder="0" allowfullscreen></iframe></div>';
						}
						if(photomentor_thishref.indexOf('vimeo') + 1) {
							//Vimeo Video
							var videoid_split = photomentor_thishref.split('m/'),
								videoid = videoid_split[1],
								photomentor_pswp_html = '<div class="photomentor_pswp_video_wrapper"><iframe width="100%" height="100%" src="https://player.vimeo.com/video/' + videoid + '?api=1&amp;title=0&amp;byline=0&amp;portrait=0&autoplay=0&loop=0&controls=1" frameborder="0" webkitAllowFullScreen allowFullScreen></iframe></div>';
						}
						var this_item = {
							html : photomentor_pswp_html,
                            title: this.items[i].capt
						};
						$pswp_gallery_array['photomentor_gallery_' + photomentor_uniqid].slides.push(this_item);
					} else {
						var item_size = this.items[i].size.split('x'),
							item_width = item_size[0],
							item_height = item_size[1],
							this_item = {
								src : photomentor_thishref,
								w : item_width,
								h : item_height,
                                title: this.items[i].capt
							};
						$pswp_gallery_array['photomentor_gallery_' + photomentor_uniqid].slides.push(this_item);
					}
				}
				if (!last_demo_load) {
					this.showed++;
				}
			}

			var $photomentor_newItems = jQuery(photomentor_what_to_append);

			if (photomentor_ins_container.data('isotope')) {
				photomentor_ins_container.isotope('insert', $photomentor_newItems, function() {
					photomentor_ins_container.find('.photomentor_grid_inner').ready(function() {
						photomentor_ins_container.isotope('layout');
						this_obj.setup.call(this_obj);
					});
				});
			}
			this_obj.setup.call(this_obj);
			this_obj.preloader.call(this_obj);
		}
		jQuery('.photomentor_grid_inner').isotope("layout");
		setTimeout(function () {jQuery('.gallery_grid').isotope("layout");}, 1500);
	};

	this_array.init.call(this_array);	
}

function register_proofing_gallery($this_obj) {
	photomentor_grid_array["photomentor_grid_" + $this_obj.attr('data-uniqid')] = {};
	var this_array = photomentor_grid_array["photomentor_grid_" + $this_obj.attr('data-uniqid')];
	this_array.id = $this_obj.attr('data-uniqid');
	this_array.showed = 0;
	this_array.items = [];

	var this_items_array = this_array.items;
	if ($this_obj.find('.photomentor_grid_gallery_array').length) {
		$this_obj.find('.photomentor_grid_gallery_array').each(function() {
			jQuery(this).find('.photomentor_grid_array_item').each(function() {
				var $this = jQuery(this),
					photomentor_grid_item = {};
				photomentor_grid_item.slide_type = $this.attr('data-type');
				photomentor_grid_item.img = $this.attr('data-img');
				photomentor_grid_item.thmb = $this.attr('data-thmb');
				photomentor_grid_item.title = $this.attr('data-title');
				photomentor_grid_item.capt = $this.attr('data-caption');
				photomentor_grid_item.alt = $this.attr('data-alt');
				photomentor_grid_item.overlay = $this.attr('data-overlay');
				photomentor_grid_item.counter = $this.attr('data-counter');
				photomentor_grid_item.size = $this.attr('data-size');
				this_items_array.push(photomentor_grid_item);
			});
			jQuery(this).remove();
		});
	}

	this_array.obj = jQuery('.photomentor_grid_'+this_array.id);

	this_array.init = function () {
		var this_obj = this;
		this.setup.call(this);
		this.preloader.call(this);
	};

	this_array.preloader = function() {
		var this_obj = this,
			$this_dom = this.obj;
		if ($this_dom.find('.load_anim_grid:first').size() > 0) {
			(function (img, src) {
				img.src = src;
				img.onload = function () {
					$this_dom.find('.load_anim_grid:first').removeClass('load_anim_grid').removeClass('anim_el').animate({
						'z-index': '15'
					}, 200, function() {
						$this_dom.find('.photomentor_grid_inner').isotope('layout');
						this_obj.setup.call(this_obj);
						this_obj.preloader.call(this_obj);
					});
				};
			}(new Image(), $this_dom.find('.load_anim_grid:first').find('img').attr('src')));
		} else {
			this_obj.setup.call(this_obj);
		}
	};

	this_array.setup = function() {
		var this_obj = this,
			$this_dom = this.obj,
			$photomentor_dp = $this_dom.find('.photomentor_dp');
		if (jQuery('body').hasClass('photomentor_drag_protection')) {
			$photomentor_dp.on('mousedown',function(e){
				e.preventDefault();
			});
		}
		$this_dom.find('.grid-item').each(function(){
			if (jQuery(this).hasClass('anim_el2')) {
				jQuery(this).removeClass('anim_el2');
			}
		});
		if ($this_obj.find('.photomentor_grid_inner').size() > 0) {
			$this_dom.find('.photomentor_grid_inner').isotope('layout');
			setTimeout("jQuery('.photomentor_grid_inner').isotope('layout')",1000);
		}
	};

	this_array.init.call(this_array);
}

jQuery(window).on('elementor/frontend/init', function () {
	
	// ----------------------------------------- //
	// ---------- Gallery Grid Widget ---------- //
	// ----------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-grid.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gallery_grid_isotope_trigger')) {
				jQuery('.photomentor_gallery_grid_isotope_trigger').each(function () {
					jQuery(this).isotope();

					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}

			var $this_obj = jQuery(this);
			register_grid_gallery($this_obj) 
		});
	});
	
	
	// -------------------------------------------- //
	// ---------- Gallery Masonry Widget ---------- //
	// -------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-masonry.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gallery_masonry_isotope_trigger')) {
				jQuery('.photomentor_gallery_masonry_isotope_trigger').each(function () {
					jQuery(this).isotope();
					
					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}

			var $this_obj = jQuery(this);
			register_grid_gallery($this_obj) 
		});
	});
	
	
	// ----------------------------------------------- //
	// ---------- Gallery Media Grid Widget ---------- //
	// ----------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-media-grid.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gallery_media_grid_isotope_trigger')) {
				jQuery('.photomentor_gallery_media_grid_isotope_trigger').each(function () {
					jQuery(this).isotope();

					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}

			var $this_obj = jQuery(this);
			register_grid_gallery($this_obj) 
		});
	});
	
	
	// -------------------------------------------------- //
	// ---------- Gallery Media Masonry Widget ---------- //
	// -------------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-media-masonry.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gallery_media_masonry_isotope_trigger')) {
				jQuery('.photomentor_gallery_media_masonry_isotope_trigger').each(function () {
					jQuery(this).isotope();
					
					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}
			
			var $this_obj = jQuery(this);
			register_grid_gallery($this_obj) 
		});
	});
	
	// -------------------------------------------------- //
	// ---------- Gallery Proofing Grid Widget ---------- //
	// -------------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-proofing-grid.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gal_proofing_grid_isotope_trigger')) {
				jQuery('.photomentor_gal_proofing_grid_isotope_trigger').each(function () {
					jQuery(this).isotope();
					
					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}

			var $this_obj = jQuery(this);
			register_proofing_gallery($this_obj);
		});
	});
	
	
	// ----------------------------------------------------- //
	// ---------- Gallery Proofing Masonry Widget ---------- //
	// ----------------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-proofing-masonry.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gal_proofing_masonry_isotope_trigger')) {
				jQuery('.photomentor_gal_proofing_masonry_isotope_trigger').each(function () {
					jQuery(this).isotope();
					
					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}
			
			var $this_obj = jQuery(this);
			register_proofing_gallery($this_obj);			
		});
	});
	
	

	// -------------------------------------------------------- //
	// ---------- Gallery Media Proofing Grid Widget ---------- //
	// -------------------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-media-proofing-grid.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gal_media_proofing_grid_isotope_trigger')) {
				jQuery('.photomentor_gal_media_proofing_grid_isotope_trigger').each(function () {
					jQuery(this).isotope();
					
					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}

			var $this_obj = jQuery(this);
			register_proofing_gallery($this_obj);
		});
	});
	
	// ----------------------------------------------------------- //
	// ---------- Gallery Media Proofing Masonry Widget ---------- //
	// ----------------------------------------------------------- //
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-media-proofing-masonry.default', function ($scope) {
		jQuery($scope).find('.photomentor_grid_wrapper').each(function () {
			if (jQuery('div').is('.photomentor_gal_media_proofing_masonry_isotope_trigger')) {
				jQuery('.photomentor_gal_media_proofing_masonry_isotope_trigger').each(function () {
					jQuery(this).isotope();
					
					var container = jQuery(this);
					setTimeout(function () {
						container.isotope();
					}, 500, container);
				});
			}
			
			var $this_obj = jQuery(this);
			register_proofing_gallery($this_obj);			
		});
	});
});

// Item Approve
jQuery(document).on('click', '.grid-item-button-approve', function (event) {
	event.preventDefault();
	var item_container = jQuery(this).parents('.grid-item-proofing'),
		this_link = jQuery(this);
	if (item_container.hasClass('approved')) {
		// Already Approved
		jQuery.post(photomentor_ajaxurl.url, {
			action:'photomentor_photo_proofing',
			module_id : jQuery(this).attr('data-moduleid'),
			img_id : jQuery(this).attr('data-imgid'),
			action_type : 'remove'
		}, function (response) {
			item_container.removeClass('approved');
			item_container.addClass('unviewed');
			this_link.find('i').removeClass().addClass('pm-icon-ok-circled');
		});
	} else {
		// Not Approved
		// Already Approved
		jQuery.post(photomentor_ajaxurl.url, {
			action:'photomentor_photo_proofing',
			module_id : jQuery(this).attr('data-moduleid'),
			img_id : jQuery(this).attr('data-imgid'),
			action_type : 'approve'
		}, function (response) {
			item_container.addClass('approved');
			item_container.removeClass('unviewed');
			this_link.find('i').removeClass().addClass('pm-icon-minus-circled');
		});
		
	}
	if (item_container.hasClass('unapproved')) {
		// Was Unapproved
		item_container.removeClass('unapproved');
		item_container.find('.grid-item-button-unapprove i').removeClass().addClass('pm-icon-cancel-circled');
	}
});

// Item Unapprove
jQuery(document).on('click', '.grid-item-button-unapprove', function (event) {
	event.preventDefault();
	var item_container = jQuery(this).parents('.grid-item-proofing'),
		this_link = jQuery(this);
	if (item_container.hasClass('unapproved')) {
		// Already Unapprved
		jQuery.post(photomentor_ajaxurl.url, {
			action:'photomentor_photo_proofing',
			module_id : jQuery(this).attr('data-moduleid'),
			img_id : jQuery(this).attr('data-imgid'),
			action_type : 'remove'
		}, function (response) {
			item_container.removeClass('unapproved');
			item_container.addClass('unviewed');
			this_link.find('i').removeClass().addClass('pm-icon-cancel-circled');
		});
	} else {
		// Not Unapproved
		jQuery.post(photomentor_ajaxurl.url, {
			action:'photomentor_photo_proofing',
			module_id : jQuery(this).attr('data-moduleid'),
			img_id : jQuery(this).attr('data-imgid'),
			action_type : 'unapprove'
		}, function (response) {
			item_container.addClass('unapproved');
			item_container.removeClass('unviewed');
			this_link.find('i').removeClass().addClass('pm-icon-minus-circled');
		});
	}
	if (item_container.hasClass('approved')) {
		// Was Approved
		item_container.removeClass('approved');
		item_container.find('.grid-item-button-approve i').removeClass().addClass('pm-icon-ok-circled');
	}
});

// Email Notify
jQuery(document).on('click', '.photomentor_photo_proofing_notified', function () {
	event.preventDefault();
	var this_button = jQuery(this),
		this_wrapper = this_button.parent('.photomentor_photo_proofing_notified_wrapper'),
		this_message = this_wrapper.find('.photomentor_photo_proofing_notified_message');
	this_button.slideUp(300);
	jQuery.post(photomentor_ajaxurl.url, {
		action : 'photomentor_photo_proofing_notify',
		email : jQuery(this).attr('data-email'),
		url : document.URL,
		message: jQuery(this).attr('data-message')
	}, function (response) {
		this_wrapper.addClass('photomentor_already_notified');
		this_message.html(response).slideDown(300);
	});
});

// Filtering
jQuery('.photomentor_grid_filter li a').on('click', function(){
	jQuery(this).parents('.photomentor_grid_filter').find('a').removeClass('is-checked');
	jQuery(this).parents('.photomentor_grid_filter').find('li').removeClass('is-checked');
	jQuery(this).addClass('is-checked');
	jQuery(this).parent().addClass('is-checked');
	var filterSelector = jQuery(this).attr('data-category');
	
	jQuery(this).parents('div.photomentor_proofing_cont').find('.isotope_filtering').isotope({
		filter: filterSelector
	});
	return false;
});
