"use strict";
var photomentor_packery_array = [];

jQuery(window).on('elementor/frontend/init', function () {
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-packery.default', function ($scope) {
		jQuery($scope).find('.photomentor_packery_wrapper').each(function () {
			jQuery('.photomentor_gallery_packery_isotope_trigger').each(function () {
				jQuery(this).isotope({
					layoutMode: 'packery'
				});

				var container = jQuery(this);

				setTimeout(function () {
					container.isotope({
						layoutMode: 'packery'
					});
				}, 200, container);
			});
			
			var $this_obj = jQuery(this);
			photomentor_packery_array["photomentor_packery_" + $this_obj.attr('data-uniqid')] = {};
			var this_array = photomentor_packery_array["photomentor_packery_" + $this_obj.attr('data-uniqid')];
			this_array.id = jQuery(this).attr('data-uniqid');
			this_array.showed = 0;
			this_array.items = [];
			
			var this_items_array = this_array.items;
			if ($this_obj.find('.photomentor_packery_gallery_array').length) {
				$this_obj.find('.photomentor_packery_gallery_array').each(function() {
					jQuery(this).find('.photomentor_packery_array_item').each(function(){
						var $this = jQuery(this),
							photomentor_packery_item = {};
						photomentor_packery_item.slide_type = $this.attr('data-type');
						photomentor_packery_item.img = $this.attr('data-img');
						photomentor_packery_item.thmb = $this.attr('data-thmb');
						photomentor_packery_item.title = $this.attr('data-title');
						photomentor_packery_item.capt = $this.attr('data-caption');
						photomentor_packery_item.alt = $this.attr('data-alt');
						photomentor_packery_item.overlay = $this.attr('data-overlay');
						photomentor_packery_item.counter = $this.attr('data-counter');
						photomentor_packery_item.size = $this.attr('data-size');
						this_items_array.push(photomentor_packery_item);
					});
					jQuery(this).remove();
				});
			}
			
			this_array.obj = jQuery('.photomentor_packery_'+this_array.id);
			
			this_array.init = function () {
				var this_obj = this;
				this.obj.find('.packery_load_more').on("click", function () {
					this_obj.loadmore.call(this_obj);
				});
				this.setup.call(this);
				this.preloader.call(this);
                
                jQuery(window).on('resize', function() {
                    this_array.setup.call(this_array);
                });
			};
			
			this_array.preloader = function() {
				var this_obj = this,
					$this_dom = this.obj;
				if ($this_dom.find('.load_anim:first').size() > 0) {
					(function (img, src) {
						
						img.src = src;
						img.onload = function () {
							$this_dom.find('.load_anim:first').removeClass('load_anim').removeClass('anim_el').animate({
								'z-index': '15'
							}, 200, function() {
								$this_dom.find('.photomentor_packery_inner').isotope('layout');
								this_obj.setup.call(this_obj);
								this_obj.preloader.call(this_obj);
							});
						};
					}(new Image(), $this_dom.find('.load_anim:first').find('.packery-item-inner').attr('data-src')));
				} else {
					this_obj.setup.call(this_obj);
				}
			};
			
			this_array.setup = function() {
				var this_obj = this,
					$this_dom = this.obj,
					$photomentor_dp = $this_dom.find('.photomentor_dp');
				if (jQuery('body').hasClass('photomentor_drag_protection')) {
					$photomentor_dp.on('mousedown',function(e){
						e.preventDefault();
					});
				}
				
				$this_dom.find('.photomentor_packery_inner').each(function() {
					if (jQuery(window).width() > 760) {
						var	small_item = Math.floor((jQuery(this).width())/4),
							large_item = small_item*2;
					} else {
						small_item = Math.floor(jQuery(this).width());
						large_item = small_item;
					}
					jQuery(this).find('.packery-item').each(function(){
						if (jQuery(this).hasClass('anim_el2')) {
							jQuery(this).removeClass('anim_el2');
						}
						var set_item_width = small_item,
							set_item_height = small_item;
						if (jQuery(this).hasClass('packery-item1') || jQuery(this).hasClass('packery-item7')) {
							set_item_width = large_item;
							set_item_height = large_item;
						}
						if (jQuery(this).hasClass('packery-item4') || jQuery(this).hasClass('packery-item8')) {
							set_item_width = large_item;
							set_item_height = small_item;
						}
						jQuery(this).css({
							'width' : set_item_width+'px',
							'height' : set_item_height+'px'
						});
						if (jQuery(this).hasClass('anim_el2')) {
							jQuery(this).removeClass('anim_el2');
						}
					});
					jQuery('.photomentor_packery_inner').isotope('layout');
					setTimeout("jQuery('.photomentor_packery_inner').isotope('layout')",1000);
				});
				
			};
			
			this_array.loadmore = function() {
				var this_obj = this,
					$this_dom = this.obj,
					photomentor_what_to_append = '',
					photomentor_packery_post_per_page = $this_dom.attr('data-perload'),
					photomentor_uniqid = this.id,
					photomentor_allposts = this.items.length,
					photomentor_count = $this_dom.find('.packery-item').size(),
					photomentor_ins_container = $this_dom.find('.photomentor_packery_inner'),
					photomentor_load_more_button = $this_dom.find('.packery_load_more'),
					items_showed = this_obj.showed,
					last_demo_load = false;
				var current_count = parseInt($this_dom.find('.packery-item:last').attr('data-count'));
				
				if (this.showed >= photomentor_allposts) {
					photomentor_load_more_button.slideUp(300);
				} else {
					var photomentor_now_step = this.showed + parseInt(photomentor_packery_post_per_page) - 1;
					if ((photomentor_now_step + 1) < photomentor_allposts) {
						var photomentor_limit = photomentor_now_step;
					} else {
						if ($this_dom.hasClass('demo_mode')) {
							this_obj.showed = 0;
							if ((photomentor_now_step + 1) == photomentor_allposts) {
								last_demo_load = true;
								var photomentor_limit = photomentor_now_step;
							} else {
								this_obj.loadmore.call(this_obj);
							}
						} else {
							var photomentor_limit = photomentor_allposts - 1;
							photomentor_load_more_button.slideUp(300);
						}
					}
					
					var photomentor_swipebox_class = '';
					if (jQuery('.photomentor_single_gallery_wrapper ').size() > 0) {
						photomentor_swipebox_class = 'swipebox';
					}
					for (var i = items_showed; i <= photomentor_limit; i++) {
						current_count ++;
						if (current_count > 8) {
							current_count = 1;
						}
						var photomentor_thishref = this_obj.items[i].img,
							photomentor_what_to_append = photomentor_what_to_append +'\
								<div class="photomentor_gallery_item packery-item packery-item'+ current_count +' element anim_el anim_el2 load_anim packery_b2p" data-count="'+ current_count +'">\
									<div class="packery-item-inner" data-src="'+ this_obj.items[i].thmb +'" style="background-image: url('+ this_obj.items[i].thmb +');">\
										<a href="' + photomentor_thishref +'" class="photomentor_pswp_slide photomentor_dp photomentor_no_select" data-elementor-open-lightbox="no" data-size="'+ this_obj.items[i].size +'" data-count="'+ photomentor_count +'" data-caption="'+ this.items[i].capt +'">\
											<div class="packery-item-content">\
												<h4>'+ this_obj.items[i].title +'</h4>\
											</div>\
											<div class="packery-item-overlay"></div>\
										</a>\
										<div class="photomentor-img-preloader"></div>\
									</div>\
								</div>';
						
						photomentor_count++;
						var item_size = this_obj.items[i].size.split('x'),
							item_width = item_size[0],
							item_height = item_size[1],
							this_item = {
								src : photomentor_thishref,
								w : item_width,
								h : item_height,
                                title: this_obj.items[i].capt
							};
						if (!elementorFrontend.isEditMode()) {
							$pswp_gallery_array['photomentor_gallery_' + photomentor_uniqid].slides.push(this_item);
						}
						
						this_obj.showed++;
					}
					
					var $photomentor_newItems = jQuery(photomentor_what_to_append);
					
					if (photomentor_ins_container.data('isotope')) {
						photomentor_ins_container.isotope('insert', $photomentor_newItems, function() {
							photomentor_ins_container.find('.photomentor_packery_inner').ready(function() {
								this_obj.setup.call(this_obj);
							});
						});
					}
					this_obj.setup.call(this_obj);
					this_obj.preloader.call(this_obj);
				}
				jQuery('.photomentor_packery_inner').isotope("layout");
				setTimeout(function () {jQuery('.gallery_packery').isotope("layout");}, 1500);
			};
			
			var $this_obj = jQuery(this),
				this_obj = photomentor_packery_array["photomentor_packery_" + $this_obj.attr('data-uniqid')];
			this_obj.init.call(this_obj);
		});
	});
});
