"use strict";

function ribbon_setup() {
	if (jQuery('.photomentor_ribbon_slider_wrapper.auto_height').size() > 0) {
		jQuery('.photomentor_ribbon_slider_wrapper.auto_height').each(function() {
			var setHeight = parseInt(jQuery(this).parents('section.elementor-element').children('.elementor-container').css('min-height'),10) - parseInt(jQuery(this).parents('.elementor-column-wrap').css('padding-top'),10) - parseInt(jQuery(this).parents('.elementor-column-wrap').css('padding-bottom'),10);
			jQuery(this).height(setHeight);
			jQuery(this).find('.photomentor_ribbon_slide').each(function(){
				jQuery(this).width(setHeight*jQuery(this).attr('data-ratio'));
			});
		});
	}
	if (jQuery('.photomentor_ribbon_slider_wrapper.screen_height').size() > 0) {
		jQuery('.photomentor_ribbon_slider_wrapper.screen_height').each(function() {
			var $this = jQuery(this),
				setHeight = jQuery(window).height();
			if (jQuery('#wpadminbar').size() > 0) {
				setHeight = setHeight - jQuery('#wpadminbar').height();
			}

			if ($this.hasClass('exclude_class')) {
				if ($this.attr('data-classes') !== '') {
					var ex_classes_array = $this.attr('data-classes').split(",");
					jQuery.each(ex_classes_array, function(index,value) {
						setHeight = setHeight - jQuery(value).height();
					});
				}
			}
			if ($this.hasClass('exclude_height')) {
				if ($this.attr('data-rheight') !== '') {
					setHeight = setHeight - parseInt($this.attr('data-rheight'),10);
				}
			}

			setHeight = Math.ceil(setHeight);
			jQuery(this).height(setHeight);
			jQuery(this).find('.photomentor_ribbon_slide').each(function() {
				var set_width = Math.ceil(setHeight*jQuery(this).attr('data-ratio'));
				jQuery(this).width(set_width);
			});

			if (!jQuery('.photomentor_footer').hasClass('photomentor_template_footer_solid') && jQuery(this).attr('data-footer') !== 'yes') {
				jQuery(this).find('.photomentor_ribbon_content').css('bottom', jQuery('.photomentor_footer').height()).addClass('remove_gradient_overlay');
				jQuery(this).find('.photomentor_slider_overlay_gradient').hide();
			}

		});
	}	
}

jQuery(window).on('elementor/frontend/init', function () {
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-ribbon.default', function ($scope) {
		$scope.find('.photomentor_ribbon_slider_wrapper').each(function () {
			var autoplay = jQuery(this).attr('data-autoplay'),
				speed = parseInt(jQuery(this).attr('data-speed'),10),
				pause = jQuery(this).attr('data-pause'),
				set_pad = parseInt(jQuery(this).attr('data-pad'),10);
			if (autoplay == 'yes') {
				autoplay = true;
			} else {
				autoplay = false;
			}
			if (pause == 'yes') {
				pause = true;
			} else {
				pause = false;
			}
			
			ribbon_setup();
			
			jQuery(this).on("initialized.owl.carousel", function (e) {
				jQuery(this).css("opacity", "1");
			});
			jQuery(this).owlCarousel(
				{
					items: 3,
					center: true,
					lazyLoad: true,
					loop: true,
					autoplay: autoplay,
					autoplayTimeout: speed,
					autoplayHoverPause: pause,
					autoWidth: true,
					dots: false,
					margin: set_pad,
					nav: true,
					navText: ["", ""]
				}
			);
					
			jQuery(this).trigger('refresh.owl.carousel');
			
			jQuery(window).on('resize', function () {
				var container = $scope.find('.photomentor_ribbon_slider_wrapper');

				ribbon_setup();
				container.trigger('refresh.owl.carousel');
			});
		});
	});
	elementorFrontend.hooks.addAction('frontend/element_ready/photomentor-gallery-ribbon-custom.default', function ($scope) {
		$scope.find('.photomentor_ribbon_slider_wrapper').each(function () {
			var autoplay = jQuery(this).attr('data-autoplay'),
				speed = parseInt(jQuery(this).attr('data-speed'),10),
				pause = jQuery(this).attr('data-pause'),
				set_pad = parseInt(jQuery(this).attr('data-pad'),10);
			if (autoplay == 'yes') {
				autoplay = true;
			} else {
				autoplay = false;
			}
			if (pause == 'yes') {
				pause = true;
			} else {
				pause = false;
			}
			
			ribbon_setup();
			
			jQuery(this).on("initialized.owl.carousel", function (e) {
				jQuery(this).css("opacity", "1");
			});
			jQuery(this).owlCarousel(
				{
					items: 3,
					center: true,
					lazyLoad: true,
					loop: true,
					autoplay: autoplay,
					autoplayTimeout: speed,
					autoplayHoverPause: pause,
					autoWidth: true,
					dots: false,
					margin: set_pad,
					nav: true,
					navText: ["", ""]
				}
			);
					
			jQuery(this).trigger('refresh.owl.carousel');
			
			jQuery(window).on('resize', function () {
				var container = $scope.find('.photomentor_ribbon_slider_wrapper');

				ribbon_setup();
				container.trigger('refresh.owl.carousel');
			});
		});
	});
});
